/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.oidc;

import com.floragunn.codova.config.net.ProxyConfig;
import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.enterprise.auth.oidc.JwksProviderClient;
import com.floragunn.searchguard.enterprise.auth.oidc.JwtVerifier;
import com.floragunn.searchguard.enterprise.auth.oidc.KeySetRetriever;
import com.floragunn.searchguard.enterprise.auth.oidc.OidcProviderConfig;
import com.floragunn.searchsupport.PrivilegedCode;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLHandshakeException;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.cache.HttpCacheContext;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.cache.BasicHttpCacheStorage;
import org.apache.http.impl.client.cache.CacheConfig;
import org.apache.http.impl.client.cache.CachingHttpClients;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenIdProviderClient {
    private static final Logger log = LogManager.getLogger(KeySetRetriever.class);
    private static final long CACHE_STATUS_LOG_INTERVAL_MS = 3600000L;
    private URI openIdConnectEndpoint;
    private TLSConfig tlsConfig;
    private ProxyConfig proxyConfig;
    private int requestTimeoutMs = 10000;
    private CacheConfig cacheConfig;
    private HttpCacheStorage oidcHttpCacheStorage;
    private int oidcCacheHits = 0;
    private int oidcCacheMisses = 0;
    private int oidcCacheHitsValidated = 0;
    private int oidcCacheModuleResponses = 0;
    private long oidcRequests = 0L;
    private long lastCacheStatusLog = 0L;
    private final JwksProviderClient jwkProviderClient;

    public OpenIdProviderClient(URI openIdConnectEndpoint, TLSConfig tlsConfig, ProxyConfig proxyConfig, boolean useCacheForOidConnectEndpoint) {
        this.openIdConnectEndpoint = openIdConnectEndpoint;
        this.tlsConfig = tlsConfig;
        this.proxyConfig = proxyConfig;
        if (useCacheForOidConnectEndpoint) {
            this.cacheConfig = CacheConfig.custom().setMaxCacheEntries(10).setMaxObjectSize(0x100000L).build();
            this.oidcHttpCacheStorage = new BasicHttpCacheStorage(this.cacheConfig);
        }
        this.jwkProviderClient = new JwksProviderClient(tlsConfig, proxyConfig);
    }

    public ValidationResult<OidcProviderConfig> getOidcConfiguration() throws AuthenticatorUnavailableException {
        return (ValidationResult)PrivilegedCode.execute(() -> {
            try (CloseableHttpClient httpClient = this.createHttpClient(this.oidcHttpCacheStorage);){
                ValidationResult<OidcProviderConfig> validationResult;
                block20: {
                    HttpGet httpGet = new HttpGet(this.openIdConnectEndpoint);
                    RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.getRequestTimeoutMs()).setConnectTimeout(this.getRequestTimeoutMs()).setSocketTimeout(this.getRequestTimeoutMs()).build();
                    httpGet.setConfig(requestConfig);
                    HttpCacheContext httpContext = null;
                    if (this.oidcHttpCacheStorage != null) {
                        httpContext = new HttpCacheContext();
                    }
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpGet, (HttpContext)httpContext);
                    try {
                        StatusLine statusLine;
                        if (httpContext != null) {
                            this.logCacheResponseStatus(httpContext);
                        }
                        if ((statusLine = response.getStatusLine()).getStatusCode() < 200 || statusLine.getStatusCode() >= 300) {
                            throw new AuthenticatorUnavailableException("Error while retrieving OIDC config", statusLine + (response.getEntity() != null ? "\n" + EntityUtils.toString((HttpEntity)response.getEntity()) : "")).details("openid_configuration_url", (Object)this.openIdConnectEndpoint, new Object[0]);
                        }
                        HttpEntity httpEntity = response.getEntity();
                        if (httpEntity == null) {
                            throw new AuthenticatorUnavailableException("Error while retrieving OIDC config", "Empty response").details("openid_configuration_url", (Object)this.openIdConnectEndpoint, new Object[0]);
                        }
                        validationResult = OidcProviderConfig.parse(DocNode.parse((Format)Format.JSON).from(httpEntity.getContent()));
                        if (response == null) break block20;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    response.close();
                }
                return validationResult;
            }
            catch (SSLHandshakeException e) {
                throw new AuthenticatorUnavailableException("Error while retrieving OIDC config", (Throwable)e).details("openid_configuration_url", (Object)this.openIdConnectEndpoint, new Object[0]);
            }
            catch (IOException e) {
                throw new AuthenticatorUnavailableException("Error while retrieving OIDC config", (Throwable)e).details("openid_configuration_url", (Object)this.openIdConnectEndpoint, new Object[0]);
            }
            catch (DocumentParseException e) {
                throw new AuthenticatorUnavailableException("Error while retrieving OIDC config", (Throwable)e).details("openid_configuration_url", (Object)this.openIdConnectEndpoint, new Object[0]);
            }
        }, AuthenticatorUnavailableException.class);
    }

    public JsonWebKeys getJsonWebKeys() throws AuthenticatorUnavailableException {
        return this.jwkProviderClient.getJsonWebKeys(this.getJwksUri());
    }

    public TokenResponse callTokenEndpoint(Map<String, String> params) throws AuthenticatorUnavailableException {
        URI tokenEndpoint;
        ArrayList<BasicNameValuePair> request = new ArrayList<BasicNameValuePair>(params.size() + 1);
        request.add(new BasicNameValuePair("grant_type", "authorization_code"));
        for (Map.Entry<String, String> entry : params.entrySet()) {
            request.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        try {
            tokenEndpoint = ((OidcProviderConfig)this.getOidcConfiguration().get()).getTokenEndpoint();
        }
        catch (ConfigValidationException e) {
            throw new AuthenticatorUnavailableException("Invalid token endpoint in OIDC metadata", (Throwable)e).details("openid_configuration_url", (Object)this.openIdConnectEndpoint, new Object[0]);
        }
        return (TokenResponse)PrivilegedCode.execute(() -> {
            try (CloseableHttpClient httpClient = this.createHttpClient(null);){
                TokenResponse tokenResponse;
                block16: {
                    HttpPost httpPost = new HttpPost(tokenEndpoint);
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(request, "utf-8"));
                    RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.getRequestTimeoutMs()).setConnectTimeout(this.getRequestTimeoutMs()).setSocketTimeout(this.getRequestTimeoutMs()).build();
                    httpPost.setConfig(requestConfig);
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                    try {
                        String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                        StatusLine statusLine = response.getStatusLine();
                        if (response.getStatusLine().getStatusCode() >= 300 || response.getStatusLine().getStatusCode() < 200) {
                            throw new AuthenticatorUnavailableException("Error exchanging OIDC auth_code", statusLine + (responseBody != null ? "\n" + responseBody : "")).details("openid_configuration_url", (Object)this.openIdConnectEndpoint, new Object[]{"token_endpoint", tokenEndpoint});
                        }
                        Map responseJsonBody = DocReader.json().readObject(responseBody);
                        tokenResponse = new TokenResponse(responseJsonBody);
                        if (response == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    response.close();
                }
                return tokenResponse;
            }
            catch (IOException e) {
                throw new AuthenticatorUnavailableException("Error exchanging OIDC auth_code", (Throwable)e).details("openid_configuration_url", (Object)this.openIdConnectEndpoint, new Object[]{"token_endpoint", tokenEndpoint});
            }
            catch (DocumentParseException | UnexpectedDocumentStructureException e) {
                throw new AuthenticatorUnavailableException("Error exchanging OIDC auth_code", e).details("openid_configuration_url", (Object)this.openIdConnectEndpoint, new Object[]{"token_endpoint", tokenEndpoint});
            }
        }, AuthenticatorUnavailableException.class);
    }

    public HttpResponse callTokenEndpoint(byte[] body, ContentType contentType) throws AuthenticatorUnavailableException {
        URI tokenEndpoint;
        try {
            tokenEndpoint = ((OidcProviderConfig)this.getOidcConfiguration().get()).getTokenEndpoint();
        }
        catch (ConfigValidationException e) {
            throw new AuthenticatorUnavailableException("Invalid token endpoint in OIDC metadata", (Throwable)e).details("openid_configuration_url", (Object)this.openIdConnectEndpoint, new Object[0]);
        }
        return (HttpResponse)PrivilegedCode.execute(() -> {
            try (CloseableHttpClient httpClient = this.createHttpClient(null);){
                BasicHttpResponse basicHttpResponse;
                block14: {
                    HttpPost httpPost = new HttpPost(tokenEndpoint);
                    httpPost.setEntity((HttpEntity)new ByteArrayEntity(body, contentType));
                    RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(this.getRequestTimeoutMs()).setConnectTimeout(this.getRequestTimeoutMs()).setSocketTimeout(this.getRequestTimeoutMs()).build();
                    httpPost.setConfig(requestConfig);
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
                    try {
                        BasicHttpResponse copiedResponse = new BasicHttpResponse(response.getStatusLine());
                        copiedResponse.setEntity((HttpEntity)new ByteArrayEntity(EntityUtils.toByteArray((HttpEntity)response.getEntity()), ContentType.getOrDefault((HttpEntity)response.getEntity())));
                        basicHttpResponse = copiedResponse;
                        if (response == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    response.close();
                }
                return basicHttpResponse;
            }
            catch (IOException e) {
                throw new AuthenticatorUnavailableException("Error exchanging OIDC auth_code", (Throwable)e).details("openid_configuration_url", (Object)this.openIdConnectEndpoint, new Object[]{"token_endpoint", tokenEndpoint});
            }
        }, AuthenticatorUnavailableException.class);
    }

    URI getJwksUri() throws AuthenticatorUnavailableException {
        try {
            return ((OidcProviderConfig)this.getOidcConfiguration().get()).getJwksUri();
        }
        catch (ConfigValidationException e) {
            throw new AuthenticatorUnavailableException("Invalid jwk_uri in OIDC metadata", (Throwable)e).details("openid_configuration_url", (Object)this.openIdConnectEndpoint, new Object[0]);
        }
    }

    public Map<String, Object> callUserInfoEndpoint(String accessToken, JwtVerifier userInfoJwtVerifier) throws AuthenticatorUnavailableException {
        URI userInfoEndpoint;
        try {
            userInfoEndpoint = ((OidcProviderConfig)this.getOidcConfiguration().get()).getUserinfoEndpoint();
        }
        catch (ConfigValidationException e) {
            throw new AuthenticatorUnavailableException("Invalid userinfo endpoint in OIDC metadata", (Throwable)e).details("openid_configuration_url", (Object)this.openIdConnectEndpoint, new Object[0]);
        }
        return (Map)PrivilegedCode.execute(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }, AuthenticatorUnavailableException.class);
    }

    public int getRequestTimeoutMs() {
        return this.requestTimeoutMs;
    }

    public void setRequestTimeoutMs(int httpTimeoutMs) {
        this.requestTimeoutMs = httpTimeoutMs;
        this.jwkProviderClient.setRequestTimeoutMs(httpTimeoutMs);
    }

    private void logCacheResponseStatus(HttpCacheContext httpContext) {
        ++this.oidcRequests;
        switch (httpContext.getCacheResponseStatus()) {
            case CACHE_HIT: {
                ++this.oidcCacheHits;
                break;
            }
            case CACHE_MODULE_RESPONSE: {
                ++this.oidcCacheModuleResponses;
                break;
            }
            case CACHE_MISS: {
                ++this.oidcCacheMisses;
                break;
            }
            case VALIDATED: {
                ++this.oidcCacheHitsValidated;
            }
        }
        long now = System.currentTimeMillis();
        if (this.oidcRequests >= 2L && now - this.lastCacheStatusLog > 3600000L) {
            log.info("Cache status for KeySetRetriever:\noidcCacheHits: " + this.oidcCacheHits + "\noidcCacheHitsValidated: " + this.oidcCacheHitsValidated + "\noidcCacheModuleResponses: " + this.oidcCacheModuleResponses + "\noidcCacheMisses: " + this.oidcCacheMisses);
            this.lastCacheStatusLog = now;
        }
    }

    private CloseableHttpClient createHttpClient(HttpCacheStorage httpCacheStorage) {
        Object builder = httpCacheStorage != null ? CachingHttpClients.custom().setCacheConfig(this.cacheConfig).setHttpCacheStorage(httpCacheStorage) : HttpClients.custom();
        if (this.proxyConfig != null) {
            this.proxyConfig.apply(builder);
        }
        builder.useSystemProperties();
        if (this.tlsConfig != null) {
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.tlsConfig.toSSLConnectionSocketFactory());
        }
        return builder.build();
    }

    public int getOidcCacheHits() {
        return this.oidcCacheHits;
    }

    public int getOidcCacheMisses() {
        return this.oidcCacheMisses;
    }

    public int getOidcCacheHitsValidated() {
        return this.oidcCacheHitsValidated;
    }

    public int getOidcCacheModuleResponses() {
        return this.oidcCacheModuleResponses;
    }

    public static class TokenResponse {
        private final String accessToken;
        private final String tokenType;
        private final String refreshToken;
        private final long expiresIn;
        private final String idToken;

        TokenResponse(String accessToken, String tokenType, String refreshToken, long expiresIn, String idToken) {
            this.accessToken = accessToken;
            this.tokenType = tokenType;
            this.refreshToken = refreshToken;
            this.expiresIn = expiresIn;
            this.idToken = idToken;
        }

        TokenResponse(Map<String, Object> document) {
            this.accessToken = document.get("access_token") != null ? String.valueOf(document.get("access_token")) : null;
            this.tokenType = document.get("token_type") != null ? String.valueOf(document.get("token_type")) : null;
            this.refreshToken = document.get("refresh_token") != null ? String.valueOf(document.get("refresh_token")) : null;
            this.idToken = document.get("id_token") != null ? String.valueOf(document.get("id_token")) : null;
            this.expiresIn = document.get("expires_in") instanceof Number ? Long.valueOf(((Number)document.get("expires_in")).longValue()) : null;
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public String getTokenType() {
            return this.tokenType;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public long getExpiresIn() {
            return this.expiresIn;
        }

        public String getIdToken() {
            return this.idToken;
        }

        public Map<String, Object> asMap() {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("access_token", this.accessToken);
            result.put("token_type", this.tokenType);
            result.put("refresh_token", this.refreshToken);
            result.put("expires_in", this.expiresIn);
            result.put("id_token", this.idToken);
            return result;
        }
    }
}

